<?php

function dirFiles() {
	$dirfiles = array();
	if ($dh = opendir('.')) {
		while (false !== ($entry = readdir($dh))) {
		if ($entry != "." && $entry != "..") {
			$dirfiles[] = $entry;
			}
		    }
		closedir($dh);
		}
	return $dirfiles;
}

function fillBoxes($dirfiles) {
	$vzs = array('schueler', 'studi', 'mein');
	$boxes = new stdClass();

	foreach($vzs as $v) { //load messages from json files
		unset($msg_arr_in);
		unset($msg_arr_out);
		$infile = $v.'vz_inbox.json';
		$outfile = $v.'vz_outbox.json';

		if(in_array($infile, $dirfiles)) {
			$lines = file($infile) or die('can\'t open file \''.$infile.'\'');
			$json = str_replace('\n', "<br />", implode($lines));
			$msg_arr_in = json_decode($json);
			}
		if(in_array($outfile, $dirfiles)) {
			$lines = file($outfile) or die('can\'t open file \''.$outfile.'\'');
			$json = str_replace('\n', "<br />", implode($lines));
			$msg_arr_out = json_decode($json);
			}
		$boxobj = new stdClass();
		$boxobj->loaded = (isset($msg_arr_in) && isset($msg_arr_out));
		if($boxobj->loaded) {
			$boxobj->inbox = $msg_arr_in;
			$boxobj->outbox = $msg_arr_out;
			}
		else {
			$boxobj->inbox = null;
			$boxobj->outbox = null;
			}
		$boxes->$v = $boxobj;
		}
	return $boxes;
}

function getConvs($box) {
	$convs = array();
	for($i=0; $i<2; $i++) {
		$io = ($i ? 'inbox' : 'outbox');
		$ft = ($i ? 'from' : 'to');
		foreach($box->$io as $msg) {
			if(!in_array($msg->$ft, $convs)) $convs[] = $msg->$ft;
			}
		}
	return $convs;
}

function getConvMsgs($box, $conv) {
	$msgs = array();
	for($i=0; $i<2; $i++) {
		$io = ($i ? 'inbox' : 'outbox');
		$ft = ($i ? 'from' : 'to');
		foreach($box->$io as $msg) {
			if(urlSave($msg->$ft) == $conv) $msgs[] = $msg;
			}
		}
	return $msgs;
}

function getConvDateInfo($msgs) {
	$dates = array();
	$lo = 99999999;
	$hi = 0;
	foreach($msgs as $msg) {
		if(!in_array($msg->date, $dates)) $dates[] = $msg->date;
		if(compDate($msg->date) < $lo) $lo = compDate($msg->date);
		if(compDate($msg->date) > $hi) $hi = compDate($msg->date);
		}
	return array($dates, $lo, $hi); // !!! Format of $lo and $hi is compDate !!!
}

function msgDateFilter($msgs, $from, $to) {
	$fmsgs = array();
	foreach($msgs as $msg) {
		$cdate = compDate($msg->date);
		if($cdate>=$from && $cdate<=$to) $fmsgs[] = $msg;
		}
	return $fmsgs;
}

function urlSave($s) {
	return preg_replace('/[^0-9a-zA-Z_]/', '_', $s);
}

function compDate($d) {
	return str_replace('/', '', $d);
	}

/* unused
function dispDate($d) {
	return substr($d, 0, 4).'/'.substr($d, 4, 2).'/'.substr($d, 6, 2);
	}
*/

function msgSortNfi($a, $b) {
	$a_val = str_replace('/', '', $a->date).str_replace(':', '', $a->time);
	$b_val = str_replace('/', '', $b->date).str_replace(':', '', $b->time);
	if ($a_val == $b_val) return 0;
	return (($a_val > $b_val) ? -1 : 1);
	}

function msgSortOfi($a, $b) {
	return msgSortNfi($b, $a);
}

function dateSortNfi($a, $b) {
	$a_val = compDate($a);
	$b_val = compDate($b);
	if ($a_val == $b_val) return 0;
	return (($a_val > $b_val) ? -1 : 1);
	}

function dateSortOfi($a, $b) {
	return dateSortNfi($b, $a);
}

function selectOption($val, $check, $label) {
	return '<option value="'.$val.'" '.($val == $check ? 'selected="selected"' : '').'>'.$label.'</option>';
}

function drawMessages($msg_arr) {
	foreach($msg_arr as $m) {
		echo 	'<div class="msg_box">'.
				'<div class="msg_head">'.
					'<div class="fromto">From: '.$m->from.'<br />To: '.$m->to.'</div>'.
					'<div class="datetime">'.
						'<div>'.$m->date.' '.$m->time.'</div>'.
					'</div>'.
					'<div style="clear: both;"></div>'.
				'</div>'.
				'<div class="text"><div class="subject">'.$m->subject.'</div>'.$m->text.'</div>'.
			'</div>';
		}
}

?>
