#!/usr/bin/perl
use 5.014;
use strict;
use warnings;
use diagnostics;
use JSON;
use LWP 6.04;
use HTTP::Cookies;
use utf8;

$|=1; # turn on autoflushing;

unless (defined $ARGV[1]) {
	say "Usage: perl vzmp.pl <vz> <sessid>";
	exit;
	}

my $vz = $ARGV[0];
my $sid = $ARGV[1];
say "\e[1;36mUsing:\e[00m";
say "vz: $vz\nsessid: $sid\n";

# - - - set up browser - - -
my $browser = LWP::UserAgent->new();

my @headerfields :shared = (
	'User-Agent', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/536.6 (KHTML, like Gecko) Chrome/20.0.1092.0 Safari/536.6',
	'Accept-Charset' => 'utf-8'
		);
my $cookies = HTTP::Cookies->new();
$cookies->set_cookie(0, 'PHPSESSID', $sid, '/', '.'.$vz.'vz.net', 80, 0, 0, 86400, 0);
$browser->cookie_jar($cookies);
# - - - /set up browser - - -

for(my $ioi=0; $ioi<2; $ioi++) { # - - - In/Outbox - - -
my $io = ($ioi ? 'Out' : 'In');

print $io."box ...\nPage 1";
my $url = 'http://www.'.$vz.'vz.net/Messages/'.$io.'box/p/1';
my $response = $browser->get($url, @headerfields);
my $r_cont = $response->content;

$r_cont =~ /Du hast ([0-9]+) Nachrichten/;
my $pages = (($1-($1%10))/10) + (($1%10) ? 1 : 0);

my @msg_ids = $r_cont =~ /<div id="msg_([0-9]+?)"/gs;
my $msgstr = join(", ", @msg_ids);
say ' Message-IDs: '.$msgstr.' ('.@msg_ids.')';

for(my $i=2; $i-1<$pages; $i++) {
	print "Page ".$i;
	$url = 'http://www.'.$vz.'vz.net/Messages/'.$io.'box/p/'.$i;
	$response = $browser->get($url, @headerfields);
	$r_cont = $response->content;

	my @msg_ids_temp = $r_cont =~ /<div id="msg_([0-9]+?)"/gs;
	$msgstr = join(", ", @msg_ids_temp);
	say ' Message-IDs: '.$msgstr.' ('.@msg_ids_temp.')';
	@msg_ids = (@msg_ids, @msg_ids_temp);
}

$msgstr = join(", ", @msg_ids);
my $msg_count = @msg_ids;
say 'Total message-IDs: '.$msg_count;

my @msg_arr = ();
print 'Processing Message ';

for(my $mi=0; $mi<$msg_count; $mi++) {
	print $mi.($mi+1==$msg_count ? "\n" : ', ');
	my $page = (($mi-($mi%10))/10)+1;

	my $url = 'http://www.'.$vz.'vz.net/Messages/'.$io.'box/messageId/'.$msg_ids[$mi].'/p/'.$page;
	my $timeout = $browser->timeout(30);
	my $response = $browser->get($url, @headerfields);
	my $r_cont = $response->decoded_content;

	$r_cont =~ /msg_${msg_ids[$mi]}(.+?)messages-list-header/gs;
	my $line = $1;

	my @msgs = $line =~ /([^>]*)(?:<\/a>)?\s+?<br \/><small>([0-9]{2}\.[0-9]{2}\.[0-9]{4} um [0-9]{2}:[0-9]{2} Uhr).+?((?<=lesen">).+?(?=<\/a>)).+?((?<=body_text">).+?(?=<\/div>))/s; #<- problem most likely here

	$msgs[0] =~ s/^\s+|\s+$//g;
	$msgs[2] =~ s/^\s+|\s+$//g;
	$msgs[3] =~ s/^\s+|\s+$//g;
	$msgs[3] =~ s/<br>/\n/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_1\.gif" alt="">/:)/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_2\.gif" alt="">/:D/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_3\.gif" alt="">/;)/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_4\.gif" alt="">/:(/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_5\.gif" alt="">/:P/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_6\.gif" alt="">/:'(/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_7\.gif" alt="">/:")/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_8\.gif" alt="">/:)<3/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_9\.gif" alt="">/:O/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_10\.gif" alt="">/:S/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_11\.gif" alt="">/z_z/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_12\.gif" alt="">/:&/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_13\.gif" alt="">/X(/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_14\.gif" alt="">/:)/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_15\.gif" alt="">/?_?/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_16\.gif" alt="">/<vzlogo>/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_17\.gif" alt="">/<skull>/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_18\.gif" alt="">/<hmm>/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_19\.gif" alt="">/<emo>/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_20\.gif" alt="">/<cap>/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_21\.gif" alt="">/:-*/g;
	$msgs[3] =~ s/<img.+?pvz_smilie_22\.gif" alt="">/<alien>/g;
	$msgs[3] =~ s/<a class="linkified.+?Dereferer\/\?([^"]+?)".+?<\/a>/$1/g;
	$msgs[3] =~ s/(?<=http)%3A%2F%2F/:\/\//g;
	$msgs[3] =~ s/%3A/:/g;
	$msgs[3] =~ s/%2F/\//g;
	my $name = $msgs[0];
	my $datetime = $msgs[1];
	my @datemess = $datetime =~ /^([0-9]{2})\.([0-9]{2})\.([0-9]{4})/;
	my $date = $datemess[2]."/".$datemess[1]."/".$datemess[0];
	my @t_arr = $datetime =~ /([0-9]{2}:[0-9]{2}) Uhr$/;
	my $time = $t_arr[0];
	my $subject = $msgs[2];
	my $text = "$msgs[3]";
	my $msg_obj = {
		'from' => ($ioi ? 'Me' : $name),
		'to' => ($ioi ? $name : 'Me'),
		'date' => $date,
		'time' => $time,
		'subject' => $subject,
		'text' => $text
		};
	$msg_arr[$mi] = $msg_obj;
	
}

my $json_text = encode_json \@msg_arr;

open (my $ofile, '>'.$vz.'vz_'.($ioi ? 'outbox' : 'inbox').'.json');
print $ofile $json_text."\n";
close ($ofile); 
} # - - - In/Outbox - - -
